<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the GNU General Public License, version 3 (GPL-3.0).
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    emarketing www.emarketing.com <integrations@emarketing.com>
 * @copyright 2022 emarketing AG
 * @license   https://opensource.org/licenses/GPL-3.0 GNU General Public License version 3
 */

namespace Emarketing\Service;

use Emarketing\Service\Snippets\Snippets;

/**
 * Class BingTags
 * @package Emarketing\Service
 */
class BingTags extends Snippets
{
    /**
     * @param $globalTag
     * @param $viewItem
     * @param $addToCart
     * @param $purchase
     * @return bool
     * @throws \Exception
     */
    public function savePixel($globalTag, $viewItem, $addToCart, $purchase)
    {
        $this->saveInConfiguration('BING_GLOBAL', $globalTag);
        $this->saveInConfiguration('BING_VIEWITEM', $viewItem);
        $this->saveInConfiguration('BING_ADDTOCART', $addToCart);
        $this->saveInConfiguration('BING_PURCHASE', $purchase);

        return true;
    }

    /**
     * @return string
     */
    public function getGlobalTagSnippet()
    {
        return $this->getFromConfiguration('BING_GLOBAL');
    }

    /**
     * @return string
     */
    public function getViewItemSnippet()
    {
        $snippet = $this->getFromConfiguration('BING_VIEWITEM');

        if (empty($snippet)) {
            return '';
        }

        $snippet = str_replace(['<script>', '</script>'], ['', ''], $snippet);

        $script = "<script>\nvar emarketingBingViewItem = function() {" . $this->replaceProductPageVariables($snippet) . "};\n";
        $script .= "document.addEventListener('DOMContentLoaded', emarketingBingViewItem);\n";
        $script .= "document.addEventListener('DOMContentLoaded', function(event) { prestashop.on('updatedProduct', emarketingBingViewItem)});\n</script>";

        return $script;
    }

    /**
     * @return string
     */
    public function getAddToCartSnippet()
    {
        $snippet = $this->getFromConfiguration('BING_ADDTOCART');

        if (empty($snippet)) {
            return '';
        }

        $snippet = str_replace(['<script>', '</script>'], ['', ''], $snippet);

        $script = "<script>\nvar emarketingBingAdd2Cart = function() { document.querySelectorAll('.add-to-cart, #add_to_cart button, #add_to_cart a, #add_to_cart input').forEach(function(a){\na.addEventListener('click', function(){" . $this->replaceProductPageVariables($snippet) . "});});};\n";
        $script .= "document.addEventListener('DOMContentLoaded', emarketingBingAdd2Cart);\n";
        $script .= "document.addEventListener('DOMContentLoaded', function(event) { prestashop.on('updatedProduct', emarketingBingAdd2Cart)});\n</script>";

        return $script;
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function getPurchaseSnippet()
    {
        $snippet = $this->getFromConfiguration('BING_PURCHASE');

        $order = new \Order(\Tools::getValue('id_order'));

        $currency = new \Currency($order->id_currency);

        $productIds = array();
        $products = $order->getProducts();
        foreach ($products as $product) {
            if (empty($product['product_attribute_id'])) {
                $productIds[] = $product['id_product'];
                continue;
            }

            $productIds[] = $product['id_product'] . '-' . $product['product_attribute_id'];
        }

        return preg_replace(
            ['/\'REPLACE_WITH_PRODUCT_ID\'/', '/\bREPLACE_VALUE\b/', '/\bREPLACE_CURRENCY\b/'],
            ["['" . implode("','", $productIds) . "']", \Tools::ps_round($order->total_paid, 2), $currency->iso_code],
            $snippet
        );
    }

    /**
     * @param $snippet
     * @return string
     */
    private function replaceProductPageVariables($snippet)
    {
        return preg_replace(
            ['/\'REPLACE_WITH_PRODUCT_ID\'/', '/\bREPLACE_VALUE\b/', '/\'REPLACE_CURRENCY\'/'],
            ['document.getElementById("emarketing_product_id").value', 'document.getElementById("emarketing_product_price").value', 'document.getElementById("emarketing_currency").value'],
            $snippet
        );
    }
}
