<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the GNU General Public License, version 3 (GPL-3.0).
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    emarketing www.emarketing.com <integrations@emarketing.com>
 * @copyright 2022 emarketing AG
 * @license   https://opensource.org/licenses/GPL-3.0 GNU General Public License version 3
 */

namespace Emarketing\Service;

use Emarketing\Service\Snippets\Snippets;

/**
 * Class FacebookPixel
 * @package Emarketing\Service
 */
class FacebookPixel extends Snippets
{
    /**
     * @param $globalTag
     * @param $viewContent
     * @param $addToCart
     * @param $purchase
     * @return bool
     * @throws \Exception
     */
    public function savePixel($globalTag, $viewContent, $addToCart, $purchase)
    {
        $this->saveInConfiguration('FB_GLOBAL', $globalTag);
        $this->saveInConfiguration('FB_VIEWCONTENT', $viewContent);
        $this->saveInConfiguration('FB_ADDTOCART', $addToCart);
        $this->saveInConfiguration('FB_PURCHASE', $purchase);

        return true;
    }

    /**
     * @return string
     */
    public function getGlobalTagSnippet()
    {
        return $this->getFromConfiguration('FB_GLOBAL');
    }

    /**
     * @return string
     */
    public function getViewContentSnippet()
    {
        $snippet = $this->getFromConfiguration('FB_VIEWCONTENT');

        if (empty($snippet)) {
            return '';
        }

        $snippet = str_replace(['<script>', '</script>'], ['', ''], $snippet);

        $script = "<script>\nvar emarketingFBViewContent = function() {" . $this->replaceProductPageVariables($snippet) . "};\n";
        $script .= "document.addEventListener('DOMContentLoaded', emarketingFBViewContent);\n";
        $script .= "document.addEventListener('DOMContentLoaded', function(event) { prestashop.on('updatedProduct', emarketingFBViewContent)});\n</script>";

        return $script;
    }

    /**
     * @return string
     */
    public function getAddToCartSnippet()
    {
        $snippet = $this->getFromConfiguration('FB_ADDTOCART');

        if (empty($snippet)) {
            return '';
        }

        $snippet = str_replace(['<script>', '</script>'], ['', ''], $snippet);

        $script = "<script>\nvar emarketingFBAdd2Cart = function() { document.querySelectorAll('.add-to-cart, #add_to_cart button, #add_to_cart a, #add_to_cart input').forEach(function(a){\na.addEventListener('click', function(){" . $this->replaceProductPageVariables($snippet) . "});});};\n";
        $script .= "document.addEventListener('DOMContentLoaded', emarketingFBAdd2Cart);\n";
        $script .= "document.addEventListener('DOMContentLoaded', function(event) { prestashop.on('updatedProduct', emarketingFBAdd2Cart)});\n</script>";

        return $script;
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function getPurchaseSnippet()
    {
        $snippet = $this->getFromConfiguration('FB_PURCHASE');

        $order = new \Order(\Tools::getValue('id_order'));

        $currency = new \Currency($order->id_currency);

        return preg_replace(
            ['/\bREPLACE_VALUE\b/', '/\bCURRENCY\b/'],
            [\Tools::ps_round($order->total_paid, 2), $currency->iso_code],
            $snippet
        );
    }

    /**
     * @param $snippet
     * @return string
     */
    private function replaceProductPageVariables($snippet)
    {
        return preg_replace(
            ['/\'REPLACE_CONTENT\'/', '/\'REPLACE_CATEGORY\'/', '/\'REPLACE_CONTENT_ID\'/', '/\bREPLACE_VALUE\b/', '/\'CURRENCY\'/'],
            ['document.getElementById("emarketing_product_name").value', 'document.getElementById("emarketing_product_category").value', 'document.getElementById("emarketing_product_id").value', 'document.getElementById("emarketing_product_price").value', 'document.getElementById("emarketing_currency").value'],
            $snippet
        );
    }
}
