<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the GNU General Public License, version 3 (GPL-3.0).
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    emarketing www.emarketing.com <integrations@emarketing.com>
 * @copyright 2022 emarketing AG
 * @license   https://opensource.org/licenses/GPL-3.0 GNU General Public License version 3
 */

namespace Emarketing\Service;

/**
 * Class FrontendJS
 * @package Emarketing\Service
 */
class FrontendJS
{
    /**
     * @return string
     * @throws \Exception
     */
    public function buildHeader()
    {
        $currentPage = \Context::getContext()->controller->php_self;

        $html = "<!-- emarketing start -->\n";

        $html .= $this->buildGoogleHeader($currentPage);

        $html .= $this->buildFacebookHeader($currentPage);

        $html .= $this->buildBingHeader($currentPage);

        $html .= "<!-- emarketing end -->";

        return $html;
    }

    /**
     * @param $productData
     * @return string
     */
    public function buildProductContent($productData, $currency)
    {
        if (empty($productData)) {
            return '';
        }

        $name = $productData['name'];
        foreach ($productData['attributes'] as $attribute) {
            $name .= ', '. $attribute['group'] . ' - ' . $attribute['name'];
        }

        if ($productData['id_product_attribute'] == 0) {
            $id = $productData['id'];
        } else {
            $id = $productData['id'] . '-' . $productData['id_product_attribute'];
        }

        $price = $productData['rounded_display_price'];
        if (empty($price)) {
            $price = $productData['price_amount'];
        }
        if (empty($price)) {
            $price = $productData['regular_price_amount'];
        }

        $categoryName = $productData['category_name'];

        $html = '<input type="hidden" id="emarketing_product_id" value="' . $id . '"/>';
        $html .= '<input type="hidden" id="emarketing_product_name" value="' . $name. '"/>';
        $html .= '<input type="hidden" id="emarketing_product_price" value="' . $price . '"/>';
        $html .= '<input type="hidden" id="emarketing_product_category" value="' . $categoryName . '"/>';
        $html .= '<input type="hidden" id="emarketing_currency" value="' . $currency . '"/>';

        return $html;
    }

    /**
     * @param $currentPage
     * @return string
     * @throws \Exception
     */
    private function buildGoogleHeader($currentPage)
    {
        $serviceVerification = new Verification;
        $html = $serviceVerification->getTag() . "\n";

        $serviceTracker = new GoogleTracker();
        $html .= $serviceTracker->getGlobalSiteTracker() . "\n";

        if ($currentPage == 'product') {
            $html .= $serviceTracker->getViewItemTracker() . "\n";
            $html .= $serviceTracker->getAddToCartTracker() . "\n";
        }

        if ($currentPage == 'order-confirmation') {
            $html .= $serviceTracker->getConversionTracker() . "\n";
        }

        return $html;
    }

    /**
     * @param $currentPage
     * @return string
     * @throws \Exception
     */
    private function buildFacebookHeader($currentPage)
    {
        $serviceTracker = new FacebookPixel();

        $html = $serviceTracker->getGlobalTagSnippet() . "\n";

        if ($currentPage == 'product') {
            $html .= $serviceTracker->getViewContentSnippet() . "\n";
            $html .= $serviceTracker->getAddToCartSnippet() . "\n";
        }

        if ($currentPage == 'order-confirmation') {
            $html .= $serviceTracker->getPurchaseSnippet() . "\n";
        }

        return $html;
    }

    /**
     * @param $currentPage
     * @return string
     * @throws \Exception
     */
    private function buildBingHeader($currentPage)
    {
        $serviceTracker = new BingTags();

        $html = $serviceTracker->getGlobalTagSnippet() . "\n";

        if ($currentPage == 'product') {
            $html .= $serviceTracker->getViewItemSnippet() . "\n";
            $html .= $serviceTracker->getAddToCartSnippet() . "\n";
        }

        if ($currentPage == 'order-confirmation') {
            $html .= $serviceTracker->getPurchaseSnippet() . "\n";
        }

        return $html;
    }
}
