/**
 * Copyright 2022 LÍNEA GRÁFICA E.C.E S.L.
 *
 * @author    Línea Gráfica E.C.E. S.L.
 * @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 * @license   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

window.addEventListener('load', function() {
    var object_lgcookieslaw_admin15 = new LGCookiesLawAdmin15();

    object_lgcookieslaw_admin15.init();
});

function LGCookiesLawAdmin15() {
    var self = this;

    var elements_selectors;

    this.init = function() {
        self.initElements();
        self.initEvents();
    };

    this.initElements = function() {
        self.initElementsSelectors();
        self.initElementsBootstrap();
    };

    this.initElementsSelectors = function() {
        self.elements_selectors = {
            content: '#content',
            tabs: '#lg_tabs.nav li',
            tabs_link: '#lg_tabs.nav li a',
            first_tab: '#lg_tabs.nav li:nth-child(1)',
            form_groups: 'div.form-group[data-tab-id]',
            form_group: 'div.form-group[data-tab-id=',
            lang_button: '.lang-btn',
        };
    };

    this.initElementsBootstrap = function() {
        $(self.elements_selectors.content).addClass('bootstrap');

        if ($(self.elements_selectors.first_tab).length) {
            $(self.elements_selectors.first_tab).addClass('active');

            var current_tab = $(self.elements_selectors.first_tab).find('a').attr('href').replace('#', '');

            $(self.elements_selectors.form_groups).each(function() {
                if ($(this).attr('data-tab-id') == current_tab) {
                    $(this).addClass('lg-tab-active').removeClass('lg-tab-inactive');
                } else {
                    $(this).addClass('lg-tab-inactive').removeClass('lg-tab-active');
                }
            });
        }
    };

    this.initEvents = function() {
        $(self.elements_selectors.tabs_link).click(function() {
            $(self.elements_selectors.tabs).removeClass('active');
            $(this).closest('li').addClass('active');

            var current_tab = $(this).attr('href').replace('#', '');

            $(self.elements_selectors.form_groups).addClass('lg-tab-inactive').removeClass('lg-tab-active');
            $(self.elements_selectors.form_group + current_tab + ']')
                .addClass('lg-tab-active').removeClass('lg-tab-inactive');

            return false;
        });

        $(self.elements_selectors.lang_button).click(function() {
            $(this).closest('div').addClass('open');
        });
    };
}

function hideOtherLanguage(id_language_new)
{
    $('.translatable-field').hide();
    $('.lang-' + id_language_new).show();

    id_language = id_language_new;
}
