<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class PosPostePayNotificationModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->display_column_left = false;
        parent::initContent();

        $paymentGateway = $this->module->getConfiguration();

        $rfo = new PosPostePayResponseFrontOffice();

        $rfo->setMacKey($paymentGateway->macKeyResponse);

        $rfo->setOrderId(Tools::getValue('ORDERID'));
        $rfo->setShopId(Tools::getValue('SHOPID'));
        $rfo->setAuthNumber(Tools::getValue('AUTHNUMBER'));
        $rfo->setAmount(Tools::getValue('AMOUNT'));
        $rfo->setCurrency(Tools::getValue('CURRENCY'));
        $rfo->setTransactionId(Tools::getValue('TRANSACTIONID'));
        $rfo->setMac(Tools::getValue('MAC'));
        $rfo->setResult(Tools::getValue('RESULT'));
        $rfo->setAuthorMode(Tools::getValue('AUTHORMODE'));
        $rfo->setAccountingMode(Tools::getValue('ACCOUNTINGMODE'));
        $rfo->setNetwork(Tools::getValue('NETWORK'));
        $rfo->setTransactionType(Tools::getValue('TRANSACTIONTYPE'));
        $rfo->setIssuerCountry(Tools::getValue('ISSUER_COUNTRY'));
        
        $rfo->calculateMac();
        if ($rfo->responseVerified() && Tools::strtolower($rfo->getResult()) == '00') {
            $arr_exploded = explode('_', $rfo->getOrderId());

            if (count($arr_exploded) > 1) {
                $id_cart = $arr_exploded[1];
                $cart = new Cart($id_cart);
                $this->context->cart = $cart;

                if (Validate::isLoadedObject($this->context->cart) && $this->context->cart->OrderExists() == true) {
                    die;
                }

                $sql = new DbQuery();
                $sql->select('*');
                $sql->from('pospostepay_payment_verification');
                $sql->where('cart_id = "'.pSQL((int) $id_cart).'"');
                $sql->where('order_id like "'.pSQL($rfo->getOrderId()).'"');

                $infoPayment = Db::getInstance()->executeS($sql);

                if ($infoPayment) {
                    Db::getInstance()->update('pospostepay_payment_verification', array('result'=>'OK', 'transaction_id'=>(string) $rfo->getTransactionId(), 'auth_number'=>(int)  $rfo->getAuthNumber(), 'state'=>'PAYMENT ACCEPTED'), 'order_id like "'.pSQL($rfo->getOrderId()).'"');
                }

                //ok
            } else {
                Db::getInstance()->update('pospostepay_payment_verification', array('result'=>'KO'), 'order_id like "'.pSQL($rfo->getOrderId()).'"');
            }
        } else {
            Db::getInstance()->update('pospostepay_payment_verification', array('result'=>'KO'), 'order_id like "'.pSQL($rfo->getOrderId()).'"');
        }
        die;
    }
}
