<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class PosPostePayRequestFrontOffice
{
    private $urlRequest;
    private $amount;
    private $currency;
    private $orderId;
    private $shopId;

    private $url;
    private $urlBack;
    private $urlpost;

    private $accountingMode = 'I';
    private $authorMode = 'I';

    private $macKey;
    private $mac;
    private $languageId;

    private $mail;

    private $urlRedirect;
    private $jsonDSData;

    private $exponent = '';

    private $options;

    private $lockCard;

    private $plugin;
    private $pluginVersion;

    public function __construct($urlRequest)
    {
        $this->urlRequest = $urlRequest;
    }

    /**
     * @return the urlRequest
     */
    public function getUrlRequest()
    {
        return $this->urlRequest;
    }

    /**
     * @param urlRequest
     *            the urlRequest to set
     */
    public function setUrlRequest($urlRequest)
    {
        $this->urlRequest = $urlRequest;
    }

    /**
     * @return the exponent
     */
    public function getExponent()
    {
        return $this->exponent;
    }

    /**
     * @param exponent
     *            the exponent to set
     */
    public function setExponent($exponent)
    {
        $this->exponent = $exponent;
    }

    /**
     * @return the json3DSData
     */
    public function getDSData()
    {
        return $this->jsonDSData;
    }

    /**
     * @param urlRequest
     *            the json3DSData to set
     */
    public function setDSData($jsonDSData)
    {
        $this->jsonDSData = $jsonDSData;
    }

    /**
     * @return the accountingMode
     */
    public function getAccountingMode()
    {
        return $this->accountingMode;
    }

    /**
     * @param accountingMode
     *            the accountingMode to set
     */
    public function setAccountingMode($accountingMode)
    {
        $this->accountingMode = $accountingMode;
    }


    /**
     * @return the authorMode
     */
    public function getAuthorMode()
    {
        return $this->authorMode;
    }

    /**
     * @param authorMode
     *            the authorMode to set
     */
    public function setAuthorMode($authorMode)
    {
        $this->authorMode = $authorMode;
    }



    /**
     * @return the shopId
     */
    public function getShopId()
    {
        return $this->shopId;
    }

    /**
     * @param shopId
     *            the shopId to set
     */
    public function setShopId($shopId)
    {
        $this->shopId = $shopId;
    }

    /**
     * @return the amount
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param amount
     *            the amount to set
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    /**
     * @return the orderId
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param orderId
     *            the orderId to set
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
    }

    /**
     * @return the url
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param url
     *            the url to set
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return the urlBack
     */
    public function getUrlBack()
    {
        return $this->urlBack;
    }

    /**
     * @param urlBack
     *            the urlBack to set
     */
    public function setUrlBack($urlBack)
    {
        $this->urlBack = $urlBack;
    }

    /**
     * @return the macKey
     */
    public function getMacKey()
    {
        return $this->macKey;
    }

    /**
     * @param macKey
     *            the macKey to set
     */
    public function setMacKey($macKey)
    {
        $this->macKey = $macKey;
    }

    /**
     * @return the mail
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param mail
     *            the mail to set
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return the languageId
     */
    public function getLanguageId()
    {
        return $this->languageId;
    }

    /**
     * @param languageId
     *            the languageId to set
     */
    public function setLanguageId($languageId)
    {
        $this->languageId = $languageId;
    }

    /**
     * @return the urlpost
     */
    public function getUrlpost()
    {
        return $this->urlpost;
    }

    /**
     * @param urlpost
     *            the urlpost to set
     */
    public function setUrlpost($urlpost)
    {
        $this->urlpost = $urlpost;
    }

    /**
     * @return the mac
     */
    public function getMac()
    {
        return $this->mac;
    }

    /**
     * @param mac
     *            the mac to set
     */
    public function setMac($mac)
    {
        $this->mac = $mac;
    }

    /**
     * @return the options
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * @param options
     *            the options to set
     */
    public function setOptions($options)
    {
        $this->options = $options;
    }

    /*
     * public function getFields(){ List<String> fields = new ArrayList<String>();
     * }
     */

    public function getLockCard()
    {
        return $this->lockCard;
    }

    public function setLockCard($lockCard)
    {
        $this->lockCard = $lockCard;
    }

    public function getPlugin()
    {
        return $this->plugin;
    }

    public function setPlugin($plugin)
    {
        $this->plugin = $plugin;
    }

    public function getPluginVersion()
    {
        return $this->pluginVersion;
    }

    public function setPluginVersion($pluginVersion)
    {
        $this->pluginVersion = $pluginVersion;
    }

    public function calculateMacDsData()
    {
        $toHash = 'URLMS=';
        $toHash .= $this->urlpost;
        $toHash .= '&URLDONE=';
        $toHash .= $this->url;
        $toHash .= '&ORDERID=';
        $toHash .= $this->orderId;
        $toHash .= '&SHOPID=';
        $toHash .= $this->shopId;
        $toHash .= '&AMOUNT=';
        $toHash .= $this->amount;
        $toHash .= '&CURRENCY=';
        $toHash .= $this->currency;
        
        if ($this->exponent != null && !empty($this->exponent)) {
            $toHash .= '&EXPONENT=';
            $toHash .= $this->exponent;
        }
        $toHash .= '&ACCOUNTINGMODE=';
        $toHash .= $this->accountingMode;
        $toHash .= '&AUTHORMODE=';
        $toHash .= $this->authorMode;
        $toHash .= '&OPTIONS=';
        $toHash .= $this->options;
        $toHash .= '&LOCKCARD=';
        $toHash .= $this->lockCard;
        $toHash .= '&3DSDATA=';
        $toHash .= $this->jsonDSData;

        $toHash .= "&".$this->macKey;
        
        $this->mac = sha1($toHash);
    }

    public function calculateMac()
    {
        $toHash = 'URLMS=';
        $toHash .= $this->urlpost;
        $toHash .= '&URLDONE=';
        $toHash .= $this->url;
        $toHash .= '&ORDERID=';
        $toHash .= $this->orderId;
        $toHash .= '&SHOPID=';
        $toHash .= $this->shopId;
        $toHash .= '&AMOUNT=';
        $toHash .= $this->amount;
        $toHash .= '&CURRENCY=';
        $toHash .= $this->currency;

        if ($this->exponent != null && !empty($this->exponent)) {
            $toHash .= '&EXPONENT=';
            $toHash .= $this->exponent;
        }

        $toHash .= '&ACCOUNTINGMODE=';
        $toHash .= $this->accountingMode;
        $toHash .= '&AUTHORMODE=';
        $toHash .= $this->authorMode;
        $toHash .= '&OPTIONS=';
        $toHash .= $this->options;
        $toHash .= '&LOCKCARD=';
        $toHash .= $this->lockCard;

        $toHash .= "&".$this->macKey;
        $this->mac = sha1($toHash);
    }

    /**
     * @return the currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param currency
     *            the currency to set
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    public function calculateUrlRedirect()
    {
        $this->urlRedirect = $this->urlRequest;

        $this->urlRedirect .= '?PAGE=LAND&';
        if ($this->amount != null) {
            $this->urlRedirect .= 'AMOUNT='.$this->amount;
        } else {
            throw new Exception('AMOUNT required');
        }



        if ($this->currency != null) {
            $this->urlRedirect .= '&CURRENCY='.$this->currency;
        } else {
            throw new Exception('CURRENCY required');
        }

        if ($this->exponent != null && !empty($this->exponent)) {
            $this->urlRedirect .= '&EXPONENT='.$this->exponent;
        }

        if ($this->orderId != null && !empty($this->orderId)) {
            $this->urlRedirect .= '&ORDERID='.$this->orderId;
        } else {
            throw new Exception('ORDERID required');
        }

        if ($this->shopId != null && !empty($this->shopId)) {
            $this->urlRedirect .= '&SHOPID='.$this->shopId;
        } else {
            throw new Exception('SHOPID required');
        }


        if ($this->urlBack != null && !empty($this->urlBack)) {
            $this->urlRedirect .= '&URLBACK='.$this->urlBack;
        } else {
            throw new Exception('URLBACK required');
        }


        if ($this->url != null && !empty($this->url)) {
            $this->urlRedirect .= '&URLDONE='.$this->url;
        } else {
            throw new Exception('URLDONE required');
        }

        if ($this->urlpost != null && !empty($this->urlpost)) {
            $this->urlRedirect .= '&URLMS='.$this->urlpost;
        } else {
            throw new Exception('URLMS required');
        }

        if ($this->accountingMode != null && !empty($this->accountingMode)) {
            $this->urlRedirect .= '&ACCOUNTINGMODE='.$this->accountingMode;
        } else {
            throw new Exception('ACCOUNTINGMODE required');
        }

        if ($this->authorMode != null && !empty($this->authorMode)) {
            $this->urlRedirect .= '&AUTHORMODE='.$this->authorMode;
        } else {
            throw new Exception('AUTHORMODE required');
        }

        if ($this->languageId != null && !empty($this->languageId)) {
            $this->urlRedirect .= '&LANG='.$this->languageId;
        } else {
            throw new Exception('LANG required');
        }

        if ($this->options != null && !empty($this->options)) {
            $this->urlRedirect .= '&OPTIONS='.$this->options;
        } else {
            throw new Exception('OPTIONS required');
        }

        if ($this->mac != null && !empty($this->mac)) {
            $this->urlRedirect .= '&MAC='.$this->mac;
        } else {
            throw new Exception('MAC required');
        }
    }

    /**
     * @return the urlRedirect
     */
    public function getUrlRedirect()
    {
        return $this->urlRedirect;
    }

    /**
     * @param urlRedirect the urlRedirect to set
     */
    public function setUrlRedirect($urlRedirect)
    {
        $this->urlRedirect = $urlRedirect;
    }
}
