<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

require_once 'include/require.php';

if (!defined('_PS_VERSION_')) {
    exit;
}

class PosPostePay extends PaymentModule
{
    public $iso_code;

    public function __construct()
    {
        $this->name = 'pospostepay';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.4';
        $this->author = 'PostePay SpA';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => '1.7');
        $this->dependencies = array();
        $this->currencies = true;
        $this->currencies_mode = 'checkbox';
        $this->module_key = '4b2ab69bf681bcd1fc84d4fe3b9425c8';


        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('POS PostePay');
        $this->description = $this->l('This module allows you to connect your e-commerce site to the payment platform offered by PostePay for accepting online payments both with PostePay cards and with VISA and Mastercard cards issued by other banking institutions');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
    }

    public function install()
    {
        Configuration::updateValue('POSPOSTEPAY_TEST_ENABLED', 1);

        Configuration::updateValue(
            'POSPOSTEPAY_TEST_URL_PAYMENT',
            'https://acquistionlinetest.poste.it/poste/pagamenti/main'
        );
        Configuration::updateValue('POSPOSTEPAY_ACCOUNTINGMODE', 'I');
        Configuration::updateValue('POSPOSTEPAY_AUTHORMODE', 'I');

        Configuration::updateValue('POSPOSTEPAY_TEST_MAC_KEY', 'CxaBCMY-bsT3YeLVH876HvAdTkVeRLb9K2AqdFUxM-LHDcCZnja-SUzA-f8A2N-6B-fR-Bwsyt-c-2reFWkPGsGuPtSV-ZvWE--h');
        Configuration::updateValue('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE', '-xXMEH-6-yT-4fNSjp5u5XAe6NTNMkW-9-sC5fwF7xFmjYPsZRxzchfh-dhWZ883Ag-VkLf--z-zxrzjR-c-JWPUrX--cZB8Y7Hj');
        Configuration::updateValue('POSPOSTEPAY_TEST_SHOPID', '129281292800152');

        Configuration::updateValue(
            'POSPOSTEPAY_URL_PAYMENT',
            'https://acquistionline.poste.it/poste/pagamenti/main'
        );
        Configuration::updateValue('POSPOSTEPAY_MAC_KEY', '');
        Configuration::updateValue('POSPOSTEPAY_MAC_KEY_RESPONSE', '');
        Configuration::updateValue('POSPOSTEPAY_SHOPID', '');

        Configuration::updateValue('POSPOSTEPAY_MULTI_CURRENCY', 1);

        Configuration::updateValue(
            'POSPOSTEPAY_TEST_URL_API',
            'https://atpostest.ssb.it/atpos/apibo/apiBO.app'
        );

        Configuration::updateValue(
            'POSPOSTEPAY_URL_API',
            'https://atpos.ssb.it/atpos/apibo/apiBO.app'
        );

        Configuration::updateValue('POSPOSTEPAY_CARD_ENABLED', 0);
        Configuration::updateValue('POSPOSTEPAY_AMEX_ENABLED', 0);

        if (!parent::install() || !$this->registerHook('paymentOptions') || !$this->registerHook('paymentReturn') || !$this->registerHook('header')) {
            return false;
        }
        $this->installDB();
        return true;
    }

    private function installDB()
    {
        return Db::getInstance()->execute('
       CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'pospostepay_payment_verification` (
         `id` int(11) AUTO_INCREMENT PRIMARY KEY,
         `cart_id` int(11) NOT NULL,
         `currency` varchar(255) NOT NULL DEFAULT "Euro",
         `order_id` varchar(255) NOT NULL,
         `total` float(6,2) DEFAULT NULL,
         `date_trans` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
         `user` varchar(255) NOT NULL,
         `email` varchar(255) NOT NULL,
         `result` varchar(2) DEFAULT "--",
         `test` int(1) NOT NULL,
         `transaction_id` varchar(255) DEFAULT NULL,
         `id_order` int(11) DEFAULT 0,
         `state` varchar(255) DEFAULT NULL,
         `auth_number` int(11) NOT NULL
       ) ENGINE=InnoDB DEFAULT CHARSET=utf8;');
    }

    private function uninstallDB()
    {
        return Db::getInstance()->execute('
       DROP TABLE IF EXISTS '._DB_PREFIX_.'pospostepay_payment_verification;');
    }

    public function uninstall()
    {
        if (!parent::uninstall()) {
            Configuration::deleteByName('POSPOSTEPAY_TEST_ENABLED');
        }

        Configuration::deleteByName('POSPOSTEPAY_ACCOUNTINGMODE');
        Configuration::deleteByName('POSPOSTEPAY_AUTHORMODE');

        Configuration::deleteByName('POSPOSTEPAY_TEST_URL_PAYMENT');
        Configuration::deleteByName('POSPOSTEPAY_TEST_MAC_KEY');
        Configuration::deleteByName('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE');
        Configuration::deleteByName('POSPOSTEPAY_TEST_SHOPID');
        Configuration::deleteByName('POSPOSTEPAY_TEST_ERROR_URL');
        Configuration::deleteByName('POSPOSTEPAY_TEST_RESULT_URL');

        Configuration::deleteByName('POSPOSTEPAY_URL_PAYMENT');
        Configuration::deleteByName('POSPOSTEPAY_MAC_KEY');
        Configuration::deleteByName('POSPOSTEPAY_MAC_KEY_RESPONSE');
        Configuration::deleteByName('POSPOSTEPAY_SHOPID');
        Configuration::deleteByName('POSPOSTEPAY_ERROR_URL');
        Configuration::deleteByName('POSPOSTEPAY_RESULT_URL');

        Configuration::deleteByName('POSPOSTEPAY_MULTI_CURRENCY');
        Configuration::deleteByName('POSPOSTEPAY_CURRENCY_CONVERSION');

        Configuration::deleteByName('POSPOSTEPAY_TEST_URL_API');
        Configuration::deleteByName('POSPOSTEPAY_URL_API');

        Configuration::deleteByName('POSPOSTEPAY_CARD_ENABLED');
        Configuration::deleteByName('POSPOSTEPAY_AMEX_ENABLED');

        $this->uninstallDB();

        parent::uninstall();
        return true;
    }

    public function getContent()
    {
        $output = "";
        $orderStatus=null;

        if (Tools::isSubmit('btnSubmit')) {
            self::updateParam('POSPOSTEPAY_TEST_ENABLED');

            self::updateParam('POSPOSTEPAY_ACCOUNTINGMODE');

            self::updateParam('POSPOSTEPAY_SHOPID');
            self::updateParam('POSPOSTEPAY_MAC_KEY');
            self::updateParam('POSPOSTEPAY_MAC_KEY_RESPONSE');


            self::updateParam('POSPOSTEPAY_MULTI_CURRENCY');

            self::updateParam('POSPOSTEPAY_CARD_ENABLED');
            self::updateParam('POSPOSTEPAY_AMEX_ENABLED');

            $output .= $this->displayConfirmation($this->l('Settings updated'));

            $this->smarty->assign('displayOrder', "none");
        } elseif (Tools::isSubmit('exportTrans')) {
            $handle = opendir($this->getLocalPath()."tmp/");
            while (($file = readdir($handle)) !== false) {
                echo "Cancellato: " . $file . "<br/>";
                @unlink($this->getLocalPath()."tmp/". $file);
            }
            closedir($handle);

            $sql = new DbQuery();
            $sql->select('id_order,currency,total,user,email,test,auth_number,order_id,result,date_trans,state');
            $sql->from('pospostepay_payment_verification');
            $sql->where('(id_order = '.pSQL((int) Tools::getValue('SEARCH'))." or order_id like '%".pSQL(Tools::getValue('SEARCH'))."%') and id_order != 0");
            $sql->orderby('date_trans desc');
            $transactions = Db::getInstance()->ExecuteS($sql);
            $header = array('id_order', 'currency', 'amount', 'user', 'email', 'test',  'auth_number','transaction_id','result', 'date_trans', 'state');
            $array_to_export = array_merge(array($header), $transactions);
            
            $file_name = time().'.csv';
            $fd = fopen($this->getLocalPath()."tmp/".$file_name, 'w+');
            foreach ($array_to_export as $tab) {
                $line = implode(';', $tab);
                $line .= "\n";
                fwrite($fd, $line, 4096);
            }
            fclose($fd);
            Tools::redirect(_PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/tmp/'.$file_name);
        } elseif (Tools::isSubmit('search')) {
            $this->smarty->assign('linkOrder', __PS_BASE_URI__.basename(_PS_ADMIN_DIR_)."/index.php?controller=AdminOrders&id_order=");
            $this->smarty->assign('token', Tools::getAdminToken('AdminOrders'.(int)Tab::getIdFromClassName('AdminOrders').(int)$this->context->employee->id));

            $sql = new DbQuery();
            $sql->select('*');
            $sql->from('pospostepay_payment_verification');
            $sql->where('(id_order = '.pSQL((int) Tools::getValue('SEARCH'))." or order_id like '%".pSQL(Tools::getValue('SEARCH'))."%') and id_order != 0");
            $sql->orderby('date_trans desc');
            $transactions = Db::getInstance()->ExecuteS($sql);
            
            $this->smarty->assign('transactions', $transactions);
            $this->smarty->assign('Search', Tools::getValue('SEARCH'));

            $this->smarty->assign('displayOrder', "none");
        } elseif (Tools::isSubmit('showOrderStatus')) {
            $paymentGateway = new PosPostePayPaymentGateway();
            if (Configuration::get('POSPOSTEPAY_TEST_ENABLED')) {
                $paymentGateway->urlPayment = Configuration::get('POSPOSTEPAY_TEST_URL_PAYMENT');
                $paymentGateway->macKey = Configuration::get('POSPOSTEPAY_TEST_MAC_KEY');
                $paymentGateway->macKeyResponse = Configuration::get('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE');
                $paymentGateway->shopId = Configuration::get('POSPOSTEPAY_TEST_SHOPID');
                $paymentGateway->urlApi = Configuration::get('POSPOSTEPAY_TEST_URL_API');
            } else {
                $paymentGateway->urlPayment = Configuration::get('POSPOSTEPAY_URL_PAYMENT');
                $paymentGateway->macKey = Configuration::get('POSPOSTEPAY_MAC_KEY');
                $paymentGateway->macKeyResponse = Configuration::get('POSPOSTEPAY_MAC_KEY_RESPONSE');
                $paymentGateway->shopId = Configuration::get('POSPOSTEPAY_SHOPID');
                $paymentGateway->urlApi = Configuration::get('POSPOSTEPAY_URL_API');
            }

            $now = DateTime::createFromFormat('U.u', microtime(true));
            $microseconds = explode(".", $now->format("m-d-Y H:i:s.u"));
            $timestamp = date('Y-m-d')."T".date('H:i:s').".".Tools::substr($microseconds[1], 0, -3);

            $sql = new DbQuery();
            $sql->select('*');
            $sql->from('pospostepay_payment_verification');
            $sql->where('order_id like "'.pSQL(Tools::getValue('orderId')).'"');
            $infoPayment = Db::getInstance()->executeS($sql);
          
            $operatorId = "ps".sprintf("%06d", $infoPayment[0]['id_order']);
            $reqrefnum = date('YmdHis').rand(100000000000000000, 999999999999999999);

            $mac = $this->calculateMacOrderStatus($timestamp, $paymentGateway->shopId, $operatorId, $reqrefnum, Tools::getValue('orderId'), $paymentGateway->macKeyResponse);

            $campi = array(
                  'OPERATION' => 'ORDERSTATUS',
                  'TIMESTAMP' => $timestamp,
                  'SHOPID' => $paymentGateway->shopId,
                  'OPERATORID' => $operatorId,
                  'REQREFNUM' => $reqrefnum,
                  'ORDERID' => Tools::getValue('orderId'),
                  'RELEASE' => '02',
                  'MAC' => $mac
                );

            $dati = '';
            foreach ($campi as $k => $v) {
                $dati .= $k . '=' . urlencode($v) . '&';
            }
            rtrim($dati, '&');

        
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $paymentGateway->urlApi);

            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dati);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            
            $result = curl_exec($ch);

            $xml = simplexml_load_string($result, 'SimpleXMLElement', LIBXML_NOCDATA | LIBXML_NOBLANKS);
            
            $this->smarty->assign('order_id_trans', $infoPayment[0]['id_order']);
            $this->smarty->assign('orderStatusTimeStamp', $xml->Data->Authorization->Timestamp);
            $this->smarty->assign('orderStatusPaymentType', $xml->Data->Authorization->PaymentType);
            $this->smarty->assign('orderStatusAuthorizationType', $xml->Data->Authorization->AuthorizationType);
            $this->smarty->assign('orderStatusTransactionId', $xml->Data->Authorization->TransactionID);
            $this->smarty->assign('orderStatusNetwork', $xml->Data->Authorization->Network);
            $this->smarty->assign('orderStatusOrderId', $xml->Data->Authorization->OrderID);

            if ($xml->Data->Authorization->TransactionAmount != '0') {
                $this->smarty->assign('orderStatusTransactionAmount', "Euro ".Tools::substr($xml->Data->Authorization->TransactionAmount, 0, -2).".".Tools::substr($xml->Data->Authorization->TransactionAmount, -2));
            } else {
                $this->smarty->assign('orderStatusTransactionAmount', "Euro ".$xml->Data->Authorization->TransactionAmount);
            }

            if ($xml->Data->Authorization->AuthorizedAmount != '0') {
                $this->smarty->assign('orderStatusAuthorizedAmount', "Euro ".Tools::substr($xml->Data->Authorization->AuthorizedAmount, 0, -2).".".Tools::substr($xml->Data->Authorization->AuthorizedAmount, -2));
            } else {
                $this->smarty->assign('orderStatusAuthorizedAmount', "Euro ".$xml->Data->Authorization->AuthorizedAmount);
            }

            if ($xml->Data->Authorization->AccountedAmount != '0') {
                $this->smarty->assign('orderStatusAccountedAmount', "Euro ".Tools::substr($xml->Data->Authorization->AccountedAmount, 0, -2).".".Tools::substr($xml->Data->Authorization->AccountedAmount, -2));
            } else {
                $this->smarty->assign('orderStatusAccountedAmount', "Euro ".$xml->Data->Authorization->AccountedAmount);
            }

            if ($xml->Data->Authorization->RefundedAmount != '0') {
                $this->smarty->assign('orderStatusRefundedAmount', "Euro ".Tools::substr($xml->Data->Authorization->RefundedAmount, 0, -2).".".Tools::substr($xml->Data->Authorization->RefundedAmount, -2));
            } else {
                $this->smarty->assign('orderStatusRefundedAmount', "Euro ".$xml->Data->Authorization->RefundedAmount);
            }

            $this->smarty->assign('orderStatusCurrency', $xml->Data->Authorization->Currency);
            $this->smarty->assign('orderStatusTransactionStatus', $xml->Data->Authorization->TransactionStatus);
            $this->smarty->assign('orderStatusAuthorizationNumber', $xml->Data->Authorization->AuthorizationNumber);
            $this->smarty->assign('displayOrder', "block");
            $this->smarty->assign('refresh', 'true');

            curl_close($ch);
            $orderStatus=1;
        }


        return $output.$this->displayForm($orderStatus, Tools::isSubmit('submit'));
    }

    private static function updateParam($param)
    {
        Configuration::updateValue($param, trim(Tools::getValue($param)));
    }

    private static function validConfigParameter($param)
    {
        $my_module_name = '' + Tools::getValue($param);
        if ($my_module_name == '') {
            return false;
        }

        return true;
    }

    public function displayForm($orderStatus)
    {
        $this->smarty->assign('POSPOSTEPAY_TEST_ENABLED', trim(
            Tools::getValue(
                'POSPOSTEPAY_TEST_ENABLED',
                Configuration::get('POSPOSTEPAY_TEST_ENABLED')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_ACCOUNTINGMODE', trim(
            Tools::getValue(
                'POSPOSTEPAY_ACCOUNTINGMODE',
                Configuration::get('POSPOSTEPAY_ACCOUNTINGMODE')
            )
        ));


        $this->smarty->assign('POSPOSTEPAY_AUTHORMODE', trim(
            Tools::getValue(
                'POSPOSTEPAY_AUTHORMODE',
                Configuration::get('POSPOSTEPAY_AUTHORMODE')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_TEST_URL_PAYMENT', trim(
            Tools::getValue(
                'POSPOSTEPAY_TEST_URL_PAYMENT',
                Configuration::get('POSPOSTEPAY_TEST_URL_PAYMENT')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_TEST_SHOPID', trim(
            Tools::getValue(
                'POSPOSTEPAY_TEST_SHOPID',
                Configuration::get('POSPOSTEPAY_TEST_SHOPID')
            )
        ));


        $this->smarty->assign('POSPOSTEPAY_TEST_MAC_KEY', trim(
            Tools::getValue(
                'POSPOSTEPAY_TEST_MAC_KEY',
                Configuration::get('POSPOSTEPAY_TEST_MAC_KEY')
            )
        ));


        $this->smarty->assign('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE', trim(
            Tools::getValue(
                'POSPOSTEPAY_TEST_MAC_KEY_RESPONSE',
                Configuration::get('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE')
            )
        ));


        $this->smarty->assign('POSPOSTEPAY_URL_PAYMENT', trim(
            Tools::getValue(
                'POSPOSTEPAY_URL_PAYMENT',
                Configuration::get('POSPOSTEPAY_URL_PAYMENT')
            )
        ));


        $this->smarty->assign('POSPOSTEPAY_SHOPID', trim(
            Tools::getValue(
                'POSPOSTEPAY_SHOPID',
                Configuration::get('POSPOSTEPAY_SHOPID')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_MAC_KEY', trim(
            Tools::getValue(
                'POSPOSTEPAY_MAC_KEY',
                Configuration::get('POSPOSTEPAY_MAC_KEY')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_MAC_KEY_RESPONSE', trim(
            Tools::getValue(
                'POSPOSTEPAY_MAC_KEY_RESPONSE',
                Configuration::get('POSPOSTEPAY_MAC_KEY_RESPONSE')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_MULTI_CURRENCY', trim(
            Tools::getValue(
                'POSPOSTEPAY_MULTI_CURRENCY',
                Configuration::get('POSPOSTEPAY_MULTI_CURRENCY')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_CARD_ENABLED', trim(
            Tools::getValue(
                'POSPOSTEPAY_CARD_ENABLED',
                Configuration::get('POSPOSTEPAY_CARD_ENABLED')
            )
        ));

        $this->smarty->assign('POSPOSTEPAY_AMEX_ENABLED', trim(
            Tools::getValue(
                'POSPOSTEPAY_AMEX_ENABLED',
                Configuration::get('POSPOSTEPAY_AMEX_ENABLED')
            )
        ));

        $this->smarty->assign('ps_version', _PS_VERSION_);
        
        $this->smarty->assign('linkCSV', __PS_BASE_URI__.basename(_PS_ADMIN_DIR_)."/index.php?controller=AdminModules&exportTrans&configure=".$this->name."&token=");
        $this->smarty->assign('tokenCSV', Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));

        $this->smarty->assign('linkOrderStatus', __PS_BASE_URI__.basename(_PS_ADMIN_DIR_)."/index.php?controller=AdminModules&showOrderStatus&configure=".$this->name."&token=");
        $this->smarty->assign('tokenOrderStatus', Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));

        if ($orderStatus != 1) {
            $this->smarty->assign('displayOrder', "none");
            $this->smarty->assign('order_id_trans', "");
            $this->smarty->assign('orderStatusTimeStamp', "");
            $this->smarty->assign('orderStatusPaymentType', "");
            $this->smarty->assign('orderStatusAuthorizationType', "");
            $this->smarty->assign('orderStatusNetwork', "");
            $this->smarty->assign('orderStatusTransactionId', "");
            $this->smarty->assign('orderStatusOrderId', "");
            $this->smarty->assign('orderStatusTransactionAmount', "");
            $this->smarty->assign('orderStatusAuthorizedAmount', "");
            $this->smarty->assign('orderStatusAccountedAmount', "");
            $this->smarty->assign('orderStatusRefundedAmount', "");

            $this->smarty->assign('orderStatusCurrency', "");
            $this->smarty->assign('orderStatusTransactionStatus', "");
            $this->smarty->assign('orderStatusAuthorizationNumber', "");
        }

        if (Tools::getValue('type') != 1) {
            $this->smarty->assign('linkOrder', __PS_BASE_URI__.basename(_PS_ADMIN_DIR_)."/index.php?controller=AdminOrders&id_order=");
            $this->smarty->assign('token', Tools::getAdminToken('AdminOrders'.(int)Tab::getIdFromClassName('AdminOrders').(int)$this->context->employee->id));
            $sql = new DbQuery();
            $sql->select('*');
            $sql->from('pospostepay_payment_verification');
            $sql->where('id_order != 0');
            $sql->orderby('date_trans desc');
            $transactions = Db::getInstance()->ExecuteS($sql);
            $this->smarty->assign('transactions', $transactions);
        }

        $this->context->controller->addJS('https://cdnjs.cloudflare.com/ajax/libs/riot/2.6.1/riot.min.js');
        $this->context->controller->addJS('https://cdnjs.cloudflare.com/ajax/libs/riot/2.6.1/riot+compiler.min.js');

        $this->context->smarty->assign(array(
            'this_path_logo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/logo.png',
            'this_path_manuale' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/readme_it.pdf',
        ));

        $this->smarty->assign('Search', "");
        

        $html = $this->display(__FILE__, 'views/templates/admin/configuration.tpl');

        return $html.
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-alert.tpl').
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-form.tpl').
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-panel.tpl').
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-table.tpl').
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-tabs.tpl').
        $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-tags.tpl');
    }

    public function hookHeader()
    {
        if (method_exists($this->context->controller, 'addCSS')) {
            $this->context->controller->addCSS(_MODULE_DIR_.$this->name.'/views/css/pospostepay.css');
            $this->context->controller->addJS(_MODULE_DIR_.$this->name.'/views/js/front.js');
        } else {
            Tools::addCSS(_MODULE_DIR_.$this->name.'/views/css/pospostepay.css');
            Tools::addJS(_MODULE_DIR_.$this->name.'/views/js/front.js');
        }
    }

    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }

        if (!$this->checkCurrency($params['cart'])) {
            return;
        }
        $this->context->smarty->assign(array(
            'this_path_logo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/logo.png',
            'this_path_logo_amex' => Media::getMediaPath(_PS_MODULE_DIR_.$this->name."/views/img/loghi_amex.png")
        ));

        $enableCard = Configuration::get('POSPOSTEPAY_CARD_ENABLED');
        $enableAmex = Configuration::get('POSPOSTEPAY_AMEX_ENABLED');
        $payment_options = array();
        
        $newOptionPostePay = new PaymentOption();
        $newOptionPostePay->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name."/views/img/loghi_pagamento_postepay.png"))
                ->setCallToActionText($this->l('Pay with Postepay Card or App'))
                ->setModuleName('pospostepay')
                ->setAction($this->context->link->getModuleLink($this->name, 'paymentinit', array('payment'=> 'postepay'), true));
        array_push($payment_options, $newOptionPostePay);

        if ($enableCard == 1) {
            $newOptionCC = new PaymentOption();
            $linkImg = "/views/img/";
            if ($enableAmex == 1) {
                $linkImg = $linkImg."loghi_pagamento_cc_amex.png";
            } else {
                $linkImg = $linkImg."loghi_pagamento_cc.png";
            }
            $newOptionCC->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.$linkImg))
                        ->setCallToActionText($this->l('Pay with other payment cards'))
                        ->setModuleName('pospostepay')
                        ->setAction($this->context->link->getModuleLink($this->name, 'paymentinit', array('payment'=> 'creditcard'), true));
            array_push($payment_options, $newOptionCC);
        }

        return $payment_options;
    }

    public function hookPaymentReturn($params)
    {
        if (!$this->active) {
            return;
        }

        $state = $params['order']->getCurrentState();
        if (in_array($state, array(Configuration::get('PS_OS_PAYMENT'),
            Configuration::get('PS_OS_OUTOFSTOCK'), Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')))) {
            $total_to_pay = $params['order']->getOrdersTotalPaid();
            //if (_PS_VERSION_ >= "1.7.6.0") {
                $currency = new Currency($params['order']->id_currency);
                $this->smarty->assign(array(
                  'total_to_pay' => Tools::displayPrice($total_to_pay, $currency, false),
                  'status' => 'ok',
                  'id_order' => $params['order']->id,
                  'shop_name' => Configuration::get('PS_SHOP_NAME')
                ));
            /*} else {
                $this->smarty->assign(array(
                  'total_to_pay' => Tools::displayPrice($total_to_pay, $params['order'], false),
                  'status' => 'ok',
                  'id_order' => $params['order']->id,
                  'shop_name' => Configuration::get('PS_SHOP_NAME')
                ));
            }*/
            if (isset($params['order']->reference) && !empty($params['order']->reference)) {
                $this->smarty->assign('reference', $params['order']->reference);
            }
        } else {
            $this->smarty->assign('status', 'failed');
        }
        $this->smarty->assign('contact_url', $this->context->link->getPageLink('contact', true));
        return $this->fetch('module:pospostepay/views/templates/hook/payment_return.tpl');
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        $paymentGateway = $this->getConfiguration();

        if (!$paymentGateway->multiCurrency) {
            if ($currency_order->iso_code !="EUR") {
                return false;
            }
        }

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }

    public function getConfiguration()
    {
        $paymentGateway = new PosPostePayPaymentGateway();
        if (Configuration::get('POSPOSTEPAY_TEST_ENABLED')) {
            $paymentGateway->urlPayment = Configuration::get('POSPOSTEPAY_TEST_URL_PAYMENT');
            $paymentGateway->macKey = Configuration::get('POSPOSTEPAY_TEST_MAC_KEY');
            $paymentGateway->macKeyResponse = Configuration::get('POSPOSTEPAY_TEST_MAC_KEY_RESPONSE');
            $paymentGateway->shopId = Configuration::get('POSPOSTEPAY_TEST_SHOPID');
            $paymentGateway->urlApi = Configuration::get('POSPOSTEPAY_TEST_URL_API');
        } else {
            $paymentGateway->urlPayment = Configuration::get('POSPOSTEPAY_URL_PAYMENT');
            $paymentGateway->macKey = Configuration::get('POSPOSTEPAY_MAC_KEY');
            $paymentGateway->macKeyResponse = Configuration::get('POSPOSTEPAY_MAC_KEY_RESPONSE');
            $paymentGateway->shopId = Configuration::get('POSPOSTEPAY_SHOPID');
            $paymentGateway->urlApi = Configuration::get('POSPOSTEPAY_URL_API');
        }

        $paymentGateway->errorURL = $this->context->link->getModuleLink('pospostepay', 'ko');
        $paymentGateway->resultURL = $this->context->link->getModuleLink('pospostepay', 'ok');
        $paymentGateway->resultURLPost = $this->context->link->getModuleLink('pospostepay', 'notification');

        $paymentGateway->multiCurrency = Configuration::get('POSPOSTEPAY_MULTI_CURRENCY');

        $paymentGateway->accountingMode = Configuration::get('POSPOSTEPAY_ACCOUNTINGMODE');
        $paymentGateway->authorMode = Configuration::get('POSPOSTEPAY_AUTHORMODE');

        return $paymentGateway;
    }

    private function calculateMac($timestamp, $shopId, $operatorId, $reqrefnum, $transactionId, $orderId, $amount, $opDescr, $macKey)
    {
        $toHash = 'OPERATION=REFUND';
        $toHash .= '&TIMESTAMP=';
        $toHash .= $timestamp;
        $toHash .= '&SHOPID=';
        $toHash .= $shopId;
        $toHash .= '&OPERATORID=';
        $toHash .= $operatorId;
        $toHash .= '&REQREFNUM=';
        $toHash .= $reqrefnum;
        $toHash .= '&TRANSACTIONID=';
        $toHash .= $transactionId;
        $toHash .= '&ORDERID=';
        $toHash .= $orderId;
        $toHash .= '&AMOUNT=';
        $toHash .= $amount;
        $toHash .= '&CURRENCY=978';
        $toHash .= '&OPDESCR=';
        $toHash .= $opDescr;


        $toHash .= "&".$macKey;

        return sha1($toHash);
    }

    private function calculateMacOrderStatus($timestamp, $shopId, $operatorId, $reqrefnum, $orderId, $macKey)
    {
        $toHash = 'OPERATION=ORDERSTATUS';
        $toHash .= '&TIMESTAMP=';
        $toHash .= $timestamp;
        $toHash .= '&SHOPID=';
        $toHash .= $shopId;
        $toHash .= '&OPERATORID=';
        $toHash .= $operatorId;
        $toHash .= '&REQREFNUM=';
        $toHash .= $reqrefnum;
        $toHash .= '&ORDERID=';
        $toHash .= $orderId;

        $toHash .= "&".$macKey;

        return sha1($toHash);
    }
}
