<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*/

include_once('../../config/config.inc.php');
include_once('../../init.php');
include_once('../../modules/posteitaliane/posteitaliane.php');

$posteItaliane = new PosteItaliane();

if ( !$posteItaliane->isAdmin() ) exit(200);

$idOrder = Tools::getValue("posteitaliane_numero_ordine");

$shippedOrders = $posteItaliane->getShippedOrders($idOrder);

if (empty($shippedOrders)) {
    $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Status" => 2, "Error" => "Devi creare un etichetta prima di segnare l'ordine come spedito!"));
}

$idOrderCarrier = Db::getInstance()->getValue('
            SELECT `id_order_carrier`
            FROM `'._DB_PREFIX_.'order_carrier`
            WHERE `id_order` = ' . intval($idOrder));

$order = new Order($idOrder);
$order->current_state = 4;
$order->shipping_number = $shippedOrders[0]->tracking_code;
$order->update();

$orderCarrier = new OrderCarrier($idOrderCarrier);
$orderCarrier->tracking_number = $shippedOrders[0]->tracking_code;
$orderCarrier->update();

$posteItaliane->ThrowAPIResponse(array("Result" => "OK", "Status" => 1));

?>