<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*/

include_once('../../config/config.inc.php');
include_once('../../init.php');
include_once('../../modules/posteitaliane/posteitaliane.php');

$posteItaliane = new PosteItaliane();

if ( !$posteItaliane->isAdmin() ) exit(200);

$shopName = Configuration::get('PS_SHOP_NAME');
$email = Tools::getValue("posteitaliane_ticket_email");
$subject = Tools::getValue("posteitaliane_ticket_oggetto");
$service = Tools::getValue("posteitaliane_ticket_servizio", "");
$ldv = Tools::getValue("posteitaliane_ticket_ldv", "");
$body = Tools::getValue("posteitaliane_ticket_body");

$emailSubjectChunks = ["Plug-in spedizioni"];
$additionalText = "";

if ($subject == "Assistenza Spedizioni")
{
    $additionalText = ' riferito alla spedizione "' . $ldv . '"';
    $emailSubjectChunks[] = $ldv;
}

$emailSubjectChunks[] = $shopName;
$emailSubjectChunks[] = Configuration::get('PS_SHOP_DETAILS');

$emailSubject = implode(" - ", $emailSubjectChunks);

$emailBody = <<<emailBody
Buongiorno,<br><br>
Il cliente {$shopName} (email: {$email}) ha aperto un ticket di richiesta di assistenza tramite il plugin spedizioni di Poste Italiane su PrestaShop<br>
con la causale "{$subject}"{$additionalText}, segnalando la seguente problematica:<br><br>
{$body}
emailBody;

$attachments = [];

if (!empty($_FILES['posteitaliane_ticket_attachment']['name'])) {
    $attachmentContent = base64_encode(Tools::file_get_contents($_FILES['posteitaliane_ticket_attachment']['tmp_name']));
    $attachmentName = $_FILES['posteitaliane_ticket_attachment']['name'];

    $attachments[] = [
        "Content" => $attachmentContent,
        "Name" => $attachmentName
    ];
}

$request = array(
    "Method" => "PosteItalianeSendEmailMessage",
    "Params" => array(
        "Subject" => $emailSubject,
        "Message" => $emailBody,
        "Attachments" => $attachments
    )
);

$sendEmailMessageResponse = $posteItaliane->ApiRequest($request);

Tools::redirect($_SERVER["HTTP_REFERER"]);

?>