<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*/

set_time_limit(0);

include_once('../../config/config.inc.php');
include_once('../../init.php');
include_once('../../modules/posteitaliane/posteitaliane.php');

$posteItaliane = new PosteItaliane();

if ( !$posteItaliane->isAdmin() ) exit(200);

$idOrder = Tools::getValue("posteitaliane_numero_ordine");
$prestashopOrderObj = new Order($idOrder);
$carrierObj = $posteItaliane->GetCarrierById(Tools::getValue("posteitaliane_servizio"));

if (!$carrierObj)
{
    $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Status" => 2, "Error" => "Richiedi il servizio " . Tools::getValue("posteitaliane_servizio") . " dalla pagina configurazione del modulo prima di procedere a generare questa spedizione"));
}

// Check return shipment

$returnRequiredService = "Crono Reverse";

if (Tools::getValue("return") == 1 && $carrierObj->CarrierService != $returnRequiredService) $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Status" => 2, "Error" => "Per creare una spedizione di reso è necessario utilizzare il servizio " . $returnRequiredService));
if (Tools::getValue("return") != 1 && $carrierObj->CarrierService == $returnRequiredService) $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Status" => 2, "Error" => "Non è possibile utilizzare il servizio " . $returnRequiredService . " per creare una spedizione di andata"));

if (Tools::getValue("return") == 1 && $carrierObj->CarrierService == $returnRequiredService) {
	$shippedOrders = $posteItaliane->getShippedOrders($idOrder);
	
	$returnShipmentExist = false;
	
	foreach ($shippedOrders as $shippedOrder)
	{
		if ($shippedOrder->carrier_name == "POSTEITALIANE" && $shippedOrder->service_name == $returnRequiredService) $returnShipmentExist = true;
	}
	
	if ($returnShipmentExist) $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Status" => 2, "Error" => "Hai già creato una spedizione di reso"));
}

// Create shipment

$storeAddress = $posteItaliane->GetStoreAddress();

$isReturn = Tools::getValue("return") == 1;

$totalPaidValue = isset($prestashopOrderObj->total_paid) ? number_format($prestashopOrderObj->total_paid, 2, '.', '') : 0;

$shipRequest = array(
	"Method" => "Ship",
	"Params" => array(
		"to_address" => array(
			"name"    => ($isReturn) ? $storeAddress["name"] : Tools::getValue("posteitaliane_nome"),
			"company" => ($isReturn) ? $storeAddress["company"] : Tools::getValue("posteitaliane_ragionesociale"),
			"street1" => ($isReturn) ? $storeAddress["address1"] : Tools::getValue("posteitaliane_indirizzo"),
			"street2" => ($isReturn) ? $storeAddress["address2"] : Tools::getValue("posteitaliane_indirizzo2"),
			"city"    => ($isReturn) ? $storeAddress["city"] : Tools::getValue("posteitaliane_citta"),
			"state"   => ($isReturn) ? $storeAddress["state"] : Tools::getValue("posteitaliane_stato"),
			"zip"     => ($isReturn) ? $storeAddress["postcode"] : Tools::getValue("posteitaliane_codicepostale"),
			"country" => ($isReturn) ? $storeAddress["country"] : Tools::getValue("posteitaliane_nazione"),
			"phone"   => ($isReturn) ? $storeAddress["phone"] : Tools::getValue("posteitaliane_telefono"),
			"email"   => ($isReturn) ? $storeAddress["email"] : Tools::getValue("posteitaliane_email")
		),
		"from_address" => array(
			"name"    => ($isReturn) ? Tools::getValue("posteitaliane_nome") : $storeAddress["name"],
			"company" => ($isReturn) ? Tools::getValue("posteitaliane_ragionesociale") : $storeAddress["company"],
			"street1" => ($isReturn) ? Tools::getValue("posteitaliane_indirizzo") : $storeAddress["address1"],
			"street2" => ($isReturn) ? Tools::getValue("posteitaliane_indirizzo2") : $storeAddress["address2"],
			"city"    => ($isReturn) ? Tools::getValue("posteitaliane_citta") : $storeAddress["city"],
			"state"   => ($isReturn) ? Tools::getValue("posteitaliane_stato") : $storeAddress["state"],
			"zip"     => ($isReturn) ? Tools::getValue("posteitaliane_codicepostale") : $storeAddress["postcode"],
			"country" => ($isReturn) ? Tools::getValue("posteitaliane_nazione") : $storeAddress["country"],
			"phone"   => ($isReturn) ? Tools::getValue("posteitaliane_telefono") : $storeAddress["phone"],
			"email"   => ($isReturn) ? Tools::getValue("posteitaliane_email") : $storeAddress["email"],
		),
		"parcels" 				 => Tools::getValue("parcels"),
		"TotalValue"             => $totalPaidValue . " EUR",
		"TransactionID"          => "ORDER" . Tools::getValue("posteitaliane_numero_ordine"),
		"ContentDescription"     => "Goods",
		"Insurance"              => is_numeric(Tools::getValue("posteitaliane_assicurazione")) ? Tools::getValue("posteitaliane_assicurazione") : 0,
		"InsuranceCurrency"      => "EUR",
		"CashOnDelivery"         => is_numeric(Tools::getValue("posteitaliane_contrassegno")) ? Tools::getValue("posteitaliane_contrassegno") : 0,
		"CashOnDeliveryCurrency" => "EUR",
		"CashOnDeliveryType"     => is_numeric(Tools::getValue("posteitaliane_contrassegno_tipo")) ? Tools::getValue("posteitaliane_contrassegno_tipo") : 0,
		"CarrierName"            => $carrierObj->CarrierName,
		"CarrierService"         => $carrierObj->CarrierService,
		"CarrierID"              => $carrierObj->CarrierID,
		"Note"					 => "Prestashop",
		"CarrierNote"		     => Tools::getValue("posteitaliane_note"),
		"OrderID"                => "",
		"RateID"                 => "",
		"Incoterm"               => "DAP",
		"BillAccountNumber"      => "",
		"Async"                  => false,
	)
);

if (!$isReturn) {
	$selectedPointRequest = array(
		"Method" => "GetSelectedPoint",
		"Params" => array(
			"order_id" => Tools::getValue("posteitaliane_numero_ordine"),
			"url" => $_SERVER["HTTP_HOST"]
		)
	);
	
	$selectedPointResponse = $posteItaliane->SystemApiRequest($selectedPointRequest);
	
	if (!empty($selectedPointResponse->points))
	{
		$point =  $selectedPointResponse->points[0];
		$pointType = "sda" . Tools::strtolower(explode(",", $point->point_type)[0]);
	
		$shipRequest["Params"]["CarrierOptions"] = [
			["name" => $pointType, "value" => "1"],
			["name" => $pointType . "id", "value" => $point->point_id]
		];
	}
}

$resp = $posteItaliane->ApiRequest($shipRequest);

$posteItaliane->ThrowAPIResponse($resp);

?>