{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*}

{if ( $isConfigured == CONFIGURED )}
<div class="panel">
    <div class="panel-heading">
        <i class="icon-truck"></i>
        {l s='Poste Italiane' mod='posteitaliane'}
        <div class="panel-heading-action">
            <div class="btn-group">
                <a class="btn btn-default posteitalianeTooltip" href="#" id="posteitalianeSegnaOrdineComeSpedito" title="Segna l'ordine di prestashop come spedito e inserisci il tracking number">
                    <i class="icon-check"></i> Segna ordine come spedito
                </a>
                <a class="btn btn-default posteitalianeTooltip" href="#" id="posteitalianeApriTicket" title="Hai bisogno di supporto? Richiedi assistenza aprendo un ticket">
                    <i class="icon-question"></i> Apri Ticket
                </a>
            </div>
        </div>
    </div>
    <div class="tab-content panel" id="posteitalianeEtichette">
        {if ( $shippedOrdersCount > 0 )}
            <h5>Spedizioni Create</h5>
            {foreach $shippedOrders as $shippedOrder}
                <div class="row" style="margin-top: 10px">
                    <div class="col-md-8">
                        <b>Tracking Number:</b> {$shippedOrder->tracking_code|escape:'html':'utf-8'}<br>
                        <b>Servizio di spedizione scelto:</b> {$shippedOrder->carrier_name|escape:'html':'utf-8'} - {$shippedOrder->service_name|escape:'html':'utf-8'}
                    </div>
                    <div class="col-md-4 text-right">
                        <a href="#" class="posteitalianeTracciaPacco posteitalianeTooltip" tracking-code="{$shippedOrder->tracking_code|escape:'html':'utf-8'}" title="Visualizza gli aggiornamenti tracking della spedizione"><i class="icon-search" style="font-size: 24px; margin-right: 5px"></i></a>                
                        <a class="posteitalianeTooltip" href="https://cdn.shippypro.com/labels/{$shippedOrder->label_pdf_url|escape:'html':'utf-8'}" target="_blank" title="Apri e stampa l'etichetta"><i class="material-icons" style="font-size: 24px; margin-right: 5px">picture_as_pdf</i></a>
                    </div>
                </div>
                <hr>
            {/foreach }
        {else}
            Nessuna spedizione creata
        {/if}        
    </div>
    <div class="tab-content panel" id="posteitalianeRitiri">
        {if ( $pickupsCount > 0 )}
            <h5>Ritiri Prenotati</h5>
            {foreach $pickups as $pickup}
                <div class="row" style="margin-top: 10px">
                    <div class="col-md-8">
                        <b>Data:</b> {date("d/m/Y H:i", $pickup->Date)}<br>
                        <b>Numero Conferma:</b> {$pickup->ConfirmationID|escape:'html':'utf-8'}<br>
                        <b>Note:</b> {$pickup->Note|escape:'html':'utf-8'}
                    </div>
                    <div class="col-md-4 text-right">
                        {if ($pickup->PickedUP == 1)}
                            <i class="icon-check posteitalianeTooltip" style="font-size: 24px; margin-right: 5px; color: green" title="Il ritiro è stato effettuato"></i>
                        {else}
                            <i class="icon-check posteitalianeTooltip" style="font-size: 24px; margin-right: 5px" title="Il ritiro è ancora in attesa di effettuazione"></i>
                        {/if}        
                    </div>
                </div>
                <hr>
            {/foreach }
        {else}
            Nessun ritiro prenotato
        {/if}        
    </div>
    <div class="tab-content panel">
        <p>Colli</p>
        <table class="table" id="posteitalianeColli">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Peso</th>
                    <th>Altezza</th>
                    <th>Larghezza</th>
                    <th>Profondita</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
        <br>
        <button type="button" class="btn btn-primary posteitalianeTooltip" id="posteitalianeAggiungiCollo" title="Aggiungi un nuovo collo alla spedizione">Aggiungi Collo</button>
        <br><br>
        <div id="posteitalianeShipFields">
            <p>Seleziona Servizio</p>
            <select name="posteitaliane_servizio" class="chosen form-control">
                {foreach $carriers as $carrier}
                    <option value="{$carrier->CarrierID|escape:'html':'utf-8'}" carrier-service="{$carrier->CarrierService|escape:'html':'utf-8'}" {if ($carrier@index == 0)} selected {/if}>{$carrier->CarrierName|escape:'html':'utf-8'} - {$carrier->CarrierService|escape:'html':'utf-8'} - Postazione: {$carrier->Credentials->postazione|escape:'html':'utf-8'}</option>
                {/foreach }
            </select>
            <br><br>
            <p id="shipDeliveryTypeLabel">Consegna Presso</p>
            <input type="text" name="posteitaliane_nome" value="{$address->firstname|escape:'html':'utf-8'} {$address->lastname|escape:'html':'utf-8'}" placeholder="Nome" class="form-control" /><br>
            <input type="text" name="posteitaliane_ragionesociale" value="{$address->company|escape:'html':'utf-8'}" placeholder="Ragione Sociale" class="form-control" /><br>
            <input type="text" name="posteitaliane_indirizzo" value="{$address->address1|escape:'html':'utf-8'}" placeholder="Indirizzo 1" class="form-control" /><br>
            <input type="text" name="posteitaliane_indirizzo2" value="{$address->address2|escape:'html':'utf-8'}" placeholder="Indirizzo 2" class="form-control" /><br>
            <input type="text" name="posteitaliane_citta" value="{$address->city|escape:'html':'utf-8'}" placeholder="Citta" class="form-control" /><br>
            <input type="text" name="posteitaliane_codicepostale" value="{$address->postcode|escape:'html':'utf-8'}" placeholder="Codice Postale" class="form-control" /><br>
            <input type="text" name="posteitaliane_stato" value="{$state->iso_code|escape:'html':'utf-8'}" placeholder="Provincia" class="form-control" /><br>
            <select name="posteitaliane_nazione" class="form-control" />
                {foreach $countriesOptions as $countryOption}
                    <option value="{$countryOption@key|escape:'html':'utf-8'}" {if ($countryOption@key == $country->iso_code)} selected {/if}>{$countryOption|escape:'html':'utf-8'}</option>
                {/foreach }
            </select>
            <br>
            <input type="text" name="posteitaliane_telefono" value="{$address->phone|escape:'html':'utf-8'}" placeholder="Telefono" class="form-control" /><br>
            <input type="text" name="posteitaliane_email" value="{$customer->email|escape:'html':'utf-8'}" placeholder="Email" class="form-control" /><br>
            <input type="text" name="posteitaliane_note" value="{$order->note|escape:'html':'utf-8'}" placeholder="Note" class="form-control" /><br>
            <input type="number" name="posteitaliane_contrassegno" value="{$cashOnDelivery|escape:'html':'utf-8'}" placeholder="Importo Contrassegno (se il campo non è popolato la spedizione non partirà in contrassegno)" class="form-control" {if (!$isCodOrder)} disabled {/if} /><br>
            <select name="posteitaliane_contrassegno_tipo" class="form-control" {if (!$isCodOrder)} disabled {/if} />
                <option value="0" selected>Contanti</option>
                <option value="1">Assegno circolare</option>
                <option value="2">Assegno bancario</option>
                <option value="3">Tutti i metodi di pagamento</option>
            </select>
            <br>
            <input type="number" name="posteitaliane_assicurazione" value="" placeholder="Assicurazione" class="form-control" />
            <input type="hidden" name="posteitaliane_numero_ordine" class="form-control" value="{$order->id|escape:'html':'utf-8'}" />
        </div>
        <br>
        <button type="button" class="btn btn-primary posteitalianeStampaEtichetta" data-reso="0">Stampa Etichetta</button>
        <button type="button" class="btn btn-primary posteitalianeStampaEtichetta" data-reso="1">Stampa Etichetta di Reso</button>
        <button type="button" class="btn btn-primary" id="posteitalianePrenotaRitiro">Prenota Ritiro</button>
    </div>
</div>

<div class="modal fade in" id="posteitalianePrenotaRitiroModal" role="dialog">
    <div class="modal-dialog" style="overflow: hidden">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                        ×
                </button>
                <h4 class="modal-title">Prenota Ritiro</h4>
                <div id="errore-form-desc" tabindex="1"></div>
            </div>
            <div class="modal-body modal-short">
                <select name="posteitaliane_ritiro_servizio" class="chosen form-control">
                    {foreach $pickupCarriers as $pickupCarrier}
                        <option value="{$pickupCarrier->CarrierID|escape:'html':'utf-8'}" {if ($pickupCarrier@index == 0)} selected {/if}>{$pickupCarrier->CarrierName|escape:'html':'utf-8'} - Postazione: {$pickupCarrier->Credentials->postazione|escape:'html':'utf-8'}</option>
                    {/foreach }
                </select>
                <br><br>
                <input type="text" name="posteitaliane_ritiro_data" placeholder="Data e orario ritiro" class="form-control posteitalianeDatepicker" /><br>
                <input type="text" name="posteitaliane_ritiro_ragionesociale" value="{$pickupAddress->company|escape:'html':'utf-8'}" placeholder="Ragione Sociale" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_indirizzo" value="{$pickupAddress->address1|escape:'html':'utf-8'}" placeholder="Indirizzo 1" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_indirizzo2" value="{$pickupAddress->address2|escape:'html':'utf-8'}" placeholder="Indirizzo 2" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_citta" value="{$pickupAddress->city|escape:'html':'utf-8'}" placeholder="Citta" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_codicepostale" value="{$pickupAddress->postcode|escape:'html':'utf-8'}" placeholder="Codice Postale" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_stato" value="{$pickupAddress->state|escape:'html':'utf-8'}" placeholder="Provincia" class="form-control" /><br>
                <select name="posteitaliane_ritiro_nazione" class="form-control" />
                    {foreach $countriesOptions as $countryOption}
                        <option value="{$countryOption@key|escape:'html':'utf-8'}" {if ($countryOption@key == $pickupAddress->country)} selected {/if}>{$countryOption|escape:'html':'utf-8'}</option>
                    {/foreach }
                </select>
                <br>
                <input type="text" name="posteitaliane_ritiro_telefono" value="{$pickupAddress->phone|escape:'html':'utf-8'}" placeholder="Telefono" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_email" value="{$pickupAddress->email|escape:'html':'utf-8'}" placeholder="Email" class="form-control" /><br>
                <input type="text" name="posteitaliane_ritiro_note" value="" placeholder="Note" class="form-control" />
                <input type="hidden" name="posteitaliane_ritiro_numero_ordine" class="form-control" value="{$order->id|escape:'html':'utf-8'}" />
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                <button type="button" class="btn btn-primary" id="posteitalianePrenotaRitiroConferma"><i class="fa fa-check"></i>Conferma</button>
            </div>    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<div class="modal fade in" id="posteitalianeTracciaPaccoModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                        ×
                </button>
                <h4 class="modal-title">Traccia Pacco</h4>
                <div id="errore-form-desc" tabindex="1"></div>
            </div>
            <div class="modal-body modal-short">                
                <table class="table" id="posteitalianeTracciaPaccoTable">
                    <thead>
                        <tr>
                            <th>Stato</th>
                            <th>Ora</th>
                            <th>Luogo</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Esci</button>
            </div>    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<div class="modal fade in" id="posteitalianeApriTicketModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                        ×
                </button>
                <h4 class="modal-title">Apri Ticket</h4>
                <div id="errore-form-desc" tabindex="1"></div>
            </div>
            <form action="{$openTicketUrl|escape:'html':'utf-8'}" method="post" enctype="multipart/form-data" id="posteitalianeApriTicketForm">
                <div class="modal-body modal-short">
                    <label for="posteitaliane_ticket_email">Email</label>
                    <input type="email" name="posteitaliane_ticket_email" value="{$customer->email|escape:'html':'utf-8'}" class="form-control" /><br>
                    <label for="posteitaliane_ticket_oggetto">Cliente – Motivo di contatto</label>
                    <select name="posteitaliane_ticket_oggetto" class="form-control">
                        <option>Assistenza Tecnica</option>
                        <option>Assistenza Spedizioni</option>
                    </select>
                    <br>
                    <div id="posteitalianeServiceTicketDiv" style="display: none">
                        <label for="posteitaliane_ticket_servizio">Selezione Servizio</label>
                        <select name="posteitaliane_ticket_servizio" class="form-control">
                            {foreach $carriers as $carrier}
                                <option value="{$carrier->CarrierID|escape:'html':'utf-8'}" {if ($carrier@index == 0)} selected {/if}>{$carrier->CarrierName|escape:'html':'utf-8'} - {$carrier->CarrierService|escape:'html':'utf-8'} - Postazione: {$carrier->Credentials->postazione|escape:'html':'utf-8'}</option>
                            {/foreach }
                        </select>
                        <br>
                    </div>
                    <label for="posteitaliane_ticket_body">Descrizione del Problema</label>
                    <textarea rows="10" name="posteitaliane_ticket_body" class="form-control"></textarea>
                    <br>
                    <div id="posteitalianeLdvTicketDiv" style="display: none">
                        <label for="posteitaliane_ticket_ldv">Lettera di vettura/ID Ritiro</label>
                        <select name="posteitaliane_ticket_ldv" class="form-control">
                            <option></option>
                            {foreach $shippedOrders as $shippedOrder}
                                <option ldv-type="0" carrier-id="{$shippedOrder->carrier_id|escape:'html':'utf-8'}">{$shippedOrder->tracking_code|escape:'html':'utf-8'}</option>
                            {/foreach }
                            {foreach $pickups as $pickup}
                                <option ldv-type="1" carrier-id="{$pickup->CarrierID|escape:'html':'utf-8'}">{$pickup->ConfirmationID|escape:'html':'utf-8'}</option>
                            {/foreach }
                        </select>
                        <br>
                    </div>
                    <label for="posteitaliane_ticket_attachment">Allegato</label>
                    <input type="file" name="posteitaliane_ticket_attachment" class="form-control" />
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Esci</button>
                    <button type="submit" class="btn btn-primary"><i class="fa fa-check"></i>Invia</button>
                </div>
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<script>
jQuery( document ).ready(function() {

    var shippedOrdersCount = {$shippedOrdersCount|escape:'javascript':'utf-8'};
    var isCodOrder = {$isCodOrder|intval};

    $.fn.serializeObject = function() {
        var o = {};
        var a = this.serializeArray();
        $.each(a, function() {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

    $(document).on("click", "#posteitalianeAggiungiCollo", function() {
        var totalParcels = $("#posteitalianeColli tbody tr").length;
        var serviceName = getSelectedCarrierService();

        if (serviceName.indexOf("Crono") >= 0 && totalParcels != 0) {
            showError("Con i servizi Crono è possibile aggiungere solo un collo");

            return;
        }

        var parcelIndex = totalParcels + 1;

        $("#posteitalianeColli tbody").append(
            '<tr>' +
            '<td>' + parcelIndex + '</td>' +
            '<td><input type="number" min="0" class="form-control"></td>' +
            '<td><input type="number" min="0" class="form-control"></td>' +
            '<td><input type="number" min="0" class="form-control"></td>' +
            '<td><input type="number" min="0" class="form-control"></td>' +
            '<td><a href="#" class="posteItalianeRimuoviCollo"><i class="icon-remove" style="color: red"></i></a></td>' +
            '</tr>');
    });

    $(document).on("click", ".posteItalianeRimuoviCollo", function(e) {
        e.preventDefault();

        $(this).closest("tr").remove();
    });

    $(document).on("click", "#posteitalianePrenotaRitiro", function() {
        
        if (shippedOrdersCount == 0)
        {
            showError("Devi creare un etichetta prima di prenotare il ritiro!");

            return;
        }

        $("#posteitalianePrenotaRitiroModal").modal("toggle");
    });

    $(document).on("click", "#posteitalianeApriTicket", function(e) {
        e.preventDefault();

        $("#posteitalianeApriTicketModal").modal("toggle");
    });

    $(document).on("click", ".posteitalianeTracciaPacco", function(e) {
        e.preventDefault();

        $.post( "{$trackingUrl|escape:'javascript':'utf-8'}", { trackingCode : $(this).attr("tracking-code"), token: "{$ajax_token|escape:'javascript':'utf-8'}" })
        .done(function( data ) {
            if (data.Details !== undefined)
            {
                $("#posteitalianeTracciaPaccoTable tbody").empty();

                $.each(data.Details, function(ind, Detail) {
                    var date = new Date(Detail.date * 1000);
                    var dateString = date.toLocaleDateString() + " " + date.toLocaleTimeString();

                    $("#posteitalianeTracciaPaccoTable tbody").append(
                    '<tr>' +
                    '<td>' + Detail.message + '</td>' +
                    '<td>' + dateString + '</td>' +
                    '<td>' + Detail.city + '</td>' +
                    '</tr>');
                });
            }

            $("#posteitalianeTracciaPaccoModal").modal("toggle");
        });
    });

    function showError(message) {
        $.growl.error({
            title: "",
            size: "large",
            message: message
        });
    }

    function showWarning(message) {
        $.growl.warning({
            title: "",
            size: "large",
            message: message
        });
    }

    function showNotice(message) {
        $.growl.notice({
            title: "",
            size: "large",
            message: message
        });
    }

    var pendingLabelGeneration = false;
    
    $(document).on("click", ".posteitalianeStampaEtichetta", function() {
        if (pendingLabelGeneration)
        {
            showWarning("Attendi la generazione dell'etichetta!");

            return;
        }

        var parcelsRow = $("#posteitalianeColli tbody tr");

        if (parcelsRow.length == 0)
        {
            showError("Aggiungi almeno un collo!");

            return;
        }

        var inputFieldsError = false;
        var inputFieldsZeroError = false;

        $.each(parcelsRow, function() {
            $.each($(this).find("input"), function() {
                var inputValue = $(this).val();

                if (!$.isNumeric(inputValue))
                {
                    $(this).focus();

                    inputFieldsError = true;
                }

                if ($.isNumeric(inputValue) && inputValue <= 0)
                {
                    $(this).focus();

                    inputFieldsZeroError = true;
                }
            });
        });

        if (inputFieldsError)
        {
            showError("Riempi tutti i campi!");

            return;
        }

        if (inputFieldsZeroError)
        {
            showError("I valori inseriti devono essere maggiori di zero!");

            return;
        }

        var request = $("#posteitalianeShipFields input, #posteitalianeShipFields select").serializeObject();
        var parcels = [];

        $.each(parcelsRow, function() {
            parcels.push({
                "height": $(this).find("input").eq(1).val(),
                "width": $(this).find("input").eq(2).val(),
                "length": $(this).find("input").eq(3).val(),
                "weight": $(this).find("input").eq(0).val(),
            });
        });
        
        request.parcels = parcels;
        request.return = $(this).data("reso");

        if (request.return == 1 && shippedOrdersCount == 0)
        {
            showError("Devi creare un etichetta di andata prima di creare quella di reso!");
            
            return;
        }

        showWarning("Attendi la generazione dell'etichetta!");

        pendingLabelGeneration = true;

        $.post( "{$shipUrl|escape:'javascript':'utf-8'}", request)
        .done(function( data ) {
            if (data.Result == "OK" && data.Status == 1)
            {            
                $.get("", function(data)
                {
                    $("#posteitalianeEtichette").html($(data).find('#posteitalianeEtichette').html());

                    $('html, body').animate({
                        scrollTop: $("#posteitalianeEtichette").offset().top - 250
                    });
                });
                
                showNotice("Etichetta generata!");
                
                shippedOrdersCount++;
            }
            else
            {
                var errorMessage = "";

                if (data.Error !== undefined) errorMessage = data.Error;
                else if (data.ErrorMessage !== undefined) errorMessage = data.ErrorMessage;
                
                showError("Errore: " + errorMessage);
            }

            pendingLabelGeneration = false;
        });
    });

    $(document).on("click", "#posteitalianePrenotaRitiroConferma", function() {        
        if ($("input[name=posteitaliane_ritiro_data]").val() == "")
        {
            showError("Specifica la data di ritiro!");
            
            return;
        }

        var request = $("#posteitalianePrenotaRitiroModal input, #posteitalianePrenotaRitiroModal select").serializeObject();

        $.post( "{$bookPickupUrl|escape:'javascript':'utf-8'}", request)
        .done(function( data ) {
            if (data.Result == "OK")
            {
                $.get("", function(data)
                {
                    $("#posteitalianeRitiri").html($(data).find('#posteitalianeRitiri').html());

                    $('html, body').animate({
                        scrollTop: $("#posteitalianeRitiri").offset().top - 250
                    });
                });

                showNotice("Ritiro prenotato!");

                $("#posteitalianePrenotaRitiroModal").modal("toggle");
            }
            else
            {
                showError("Errore: " + data.Message);
            }
        });
    });

    var ticketSubmitFunc = function(e){
        e.preventDefault();
        
        var inputFields = $("#posteitalianeApriTicketModal input:visible, #posteitalianeApriTicketModal select:visible, #posteitalianeApriTicketModal textarea:visible");
        var inputFieldsError = false;

        $.each(inputFields, function() {
            var inputValue = $(this).val();
            var inputName = $(this).attr("name");

            if (inputName == "posteitaliane_ticket_attachment") return;

            if (inputValue == "")
            {
                $(this).focus();

                inputFieldsError = true;
            }
        });

        if (inputFieldsError)
        {
            showError("Riempi tutti i campi!");
            
            return;
        }

        $(document).off("submit", "#posteitalianeApriTicketForm", ticketSubmitFunc);
        $("#posteitalianeApriTicketForm").submit();
    }

    $(document).on("submit", "#posteitalianeApriTicketForm", ticketSubmitFunc);

    $(document).on("click", "#posteitalianeSegnaOrdineComeSpedito", function() {
        var conf = confirm("Sei sicuro?");
        if (conf != true) return;
        
        $.post( "{$markOrderAsShippedUrl|escape:'javascript':'utf-8'}", { "posteitaliane_numero_ordine": "{$order->id|escape:'javascript':'utf-8'}" })
        .done(function( data ) {
            if (data.Result == "OK")
            {
                window.location.reload();
            }
            else
            {
                showError("Errore: " + data.Error);
            }
        });
    });

    $(document).on("change", "select[name=posteitaliane_ticket_oggetto]", function() {
        var subjectVal = $(this).val();

        if (subjectVal == "Assistenza Spedizioni") {
            $("#posteitalianeServiceTicketDiv").show();
            $("#posteitalianeLdvTicketDiv").show();

            var firstLdv = $("select[name=posteitaliane_ticket_ldv] option:not(:empty)");

            if (firstLdv.length > 0)
            {
                $("select[name=posteitaliane_ticket_servizio]").val(firstLdv.attr("carrier-id"));
                $("select[name=posteitaliane_ticket_ldv]").val(firstLdv.val());
            }

            checkValidLdv();
        } else {
            $("#posteitalianeServiceTicketDiv").hide();
            $("#posteitalianeLdvTicketDiv").hide();            
        }
    });

    $('.posteitalianeTooltip').tooltipster();

    $(".posteitalianeDatepicker").datetimepicker({
        dateFormat: 'dd/mm/yy',
        minDate: 0
    });

    function checkValidLdv() {
        var carrierId = $("select[name=posteitaliane_ticket_servizio]").val();

        $("select[name=posteitaliane_ticket_ldv] option").each(function() {
            if ($(this).val() == 0) return;

            if ($(this).attr("carrier-id") != carrierId) $(this).hide();
            else $(this).show();
        });
    }

    $(document).on("change", "select[name=posteitaliane_ticket_servizio]", function() {
        checkValidLdv();
    });

    function getSelectedCarrierService()
    {
        return $("select[name=posteitaliane_servizio] option:selected").attr("carrier-service");
    }

    function checkAddresses()
    {
        var serviceName = getSelectedCarrierService();

        if (serviceName == "Crono Reverse") {
            $("input[name=posteitaliane_ragionesociale]").val("{$addressInvoice->company|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_indirizzo]").val("{$addressInvoice->address1|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_citta]").val("{$addressInvoice->city|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_codicepostale]").val("{$addressInvoice->postcode|escape:'javascript':'utf-8'}");

            if (isCodOrder) {
                $("input[name=posteitaliane_contrassegno]").attr("disabled", true);
                $("input[name=posteitaliane_contrassegno]").val("");
                $("select[name=posteitaliane_contrassegno_tipo]").attr("disabled", true);
            }

            $("#shipDeliveryTypeLabel").text("Ritiro Presso");
        }
        else {
            $("input[name=posteitaliane_ragionesociale]").val("{$address->company|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_indirizzo]").val("{$address->address1|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_citta]").val("{$address->city|escape:'javascript':'utf-8'}");
            $("input[name=posteitaliane_codicepostale]").val("{$address->postcode|escape:'javascript':'utf-8'}");

            if (isCodOrder) {
                $("input[name=posteitaliane_contrassegno]").attr("disabled", false);
                $("input[name=posteitaliane_contrassegno]").val("{$cashOnDelivery|escape:'javascript':'utf-8'}");
                $("select[name=posteitaliane_contrassegno_tipo]").attr("disabled", false);
            }

            $("#shipDeliveryTypeLabel").text("Consegna Presso");
        }
    }

    $(document).on("change", "select[name=posteitaliane_servizio]", function() {
        checkAddresses();
    });
    
    checkAddresses();
});
</script>

<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/tooltipster/3.3.0/css/tooltipster.min.css" />
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tooltipster/3.3.0/js/jquery.tooltipster.min.js"></script>
{else if ( $isConfigured == ERR_STORE_ADDRESS_NOT_CONFIGURED )}
<div class="alert alert-danger">
    Configura il tuo indirizzo mittente prima di utilizzare il modulo Poste Italiane dalla pagina Parametri Negozio > Contatto > Negozi > Dettagli di contatto
</div>
{else if ( $isConfigured == ERR_MODULE_CONFLICT )}
<div class="alert alert-danger">
    Un conflitto è stato trovato. Si prega di disattivare/disinstallare il modulo ShippyPro
</div>
{/if}