<?php

use PrestaShop\PrestaShop\Adapter\Entity\ModuleFrontController;
use PrestaShop\PrestaShop\Adapter\Entity\Tools;
use PrestaShop\Module\PulsePs\Service\Pulse;
use GuzzleHttp\Client;

/**
 * <ModuleClassName> => PulsePs
 * <FileName> => oauth.php
 * Format expected: <ModuleClassName><FileName>ModuleFrontController
 */
class PulsePsOauthModuleFrontController extends ModuleFrontController {

    private $pulse;

    public function __construct()
    {
        parent::__construct();

        $this->pulse = new Pulse();
    }

    public function setMedia()
    {
        parent::setMedia();

        $this->registerJavascript('module-pulseps-pulse_auth', 'modules/'.$this->module->name.'/views/dist/pulse_redirect.js');
    }

    public function initContent()
    {
        parent::initContent();

        $auth_code = urldecode(Tools::getValue('code'));

        try{
            $this->pulse->requestToken($auth_code);
        } catch (\Exception $e){
            dump($e->getMessage());
            die;
        }

        $this->setTemplate('module:pulseps/views/templates/front/redirect.tpl');
    }

}
