<?php

namespace PrestaShop\Module\PulsePs\Controller;

use PrestaShop\Module\PulsePs\Service\Pulse;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class OauthController extends FrameworkBundleAdminController {

    private $pulse;

    public function __construct(Pulse $pulse)
    {
        parent::__construct();

        $this->pulse = $pulse;
    }

    public function indexAction(Request $request)
    {
        $auth_code = urldecode($request->query->get('code'));

        try{
            $this->pulse->requestToken($auth_code);
            $result = json_encode([
                'success' => true
            ]);
            $alerts = [
                [
                    'type' => 'success',
                    'message' => 'Successfully connected to Pulse'
                ]
            ];
        } catch (\Exception $e){
            $result = json_encode([
                'success' => false
            ]);
            $alerts = [
                [
                    'type' => 'danger',
                    'message' => $e->getMessage()
                ]
            ];
        }

        return $this->render('@Modules/pulseps/views/templates/admin/oauth.html.twig', [
            'ps_version' => _PS_VERSION_,
            'img_dir' => _PS_IMG_,
            'shop_name' => $this->getContext()->shop->name,
            'alerts' => $alerts,
            'result' => $result
        ]);
    }

    public function disconnectAction(Request $request)
    {
        $this->pulse->clearTokens();

        return new JsonResponse([
            'success' => true
        ]);
    }

}