const CleanWebpackPlugin = require('clean-webpack-plugin');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const webpack = require('webpack');
const path = require('path');

let config = {
  entry: {
    oauth_connect: path.resolve(__dirname, './assets/back/oauth-connect.js'),
    pulse_auth: path.resolve(__dirname, './assets/back/pulse-auth.ts'),
    pulse_redirect: path.resolve(__dirname, './assets/back/pulse-redirect.ts'),
  },
  output: {
    filename: '[name].js',
    path: path.resolve(__dirname, './views/dist'),
  },
  module: {
    loaders: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: ['babel-loader'],
      },
      {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        use: 'ts-loader',
      },
    ],
  },
  stats: {
    colors: true,
  },
  devtool: 'source-map',
  plugins: [
    new CleanWebpackPlugin(),
  ],
  externals: {
    prestashop: 'prestashop',
    //$: '$',
    //jquery: 'jQuery'
  },
};

if (process.env.NODE_ENV === 'production') {
  config.plugins.push(
      new UglifyJsPlugin({
        uglifyOptions: {
          sourceMap: true,
          compress: {
            sequences: true,
            conditionals: true,
            booleans: true,
            if_return: true,
            join_vars: true,
            drop_console: true
          },
          output: {
            comments: false
          },
          minimize: true
        }
      })
  );
}

module.exports = config;