/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    Presta.Site
 * @copyright 2018 Presta.Site
 * @license   LICENSE.txt
 */
$(function () {
    $('.ttproductcountdown').each(function(){
        var labels = ttpc_labels,
            to = $(this).data('to'),
            template = _.template(ttpc_countdown_tpl),
            $ttpc = $(this).find('.ttpc-main');
        if (ttpc_show_weeks) {
            var currDate = '00:00:00:00:00';
            var nextDate = '00:00:00:00:00';
        } else {
            var currDate = '00:00:00:00';
            var nextDate = '00:00:00:00';
        }

        // Parse countdown string to an object
        function strfobj(str) {
            var pieces = str.split(':');
            var obj = {};
            labels.forEach(function(label, i) {
                obj[label] = pieces[i]
            });
            return obj;
        }
        // Return the time components that diffs
        function diff(obj1, obj2) {
            var diff = [];
            labels.forEach(function(key) {
                if (obj1[key] !== obj2[key]) {
                    diff.push(key);
                }
            });
            return diff;
        }
        // Build the layout
        var initData = strfobj(currDate);
        labels.forEach(function(label, i) {
            $ttpc.append(template({
                curr: initData[label],
                next: initData[label],
                label: label,
                label_lang: ttpc_labels_lang[label]
            }));
        });
        // Starts the countdown
        $ttpc.countdown(to, function(event) {
            var data;
            if (ttpc_show_weeks)
                var newDate = event.strftime('%w:%d:%H:%M:%S');
            else
                var newDate = event.strftime('%D:%H:%M:%S');

            if (newDate !== nextDate) {
                currDate = nextDate;
                nextDate = newDate;
                // Setup the data
                data = {
                    'curr': strfobj(currDate),
                    'next': strfobj(nextDate)
                };
                // Apply the new values to each node that changed
                diff(data.curr, data.next).forEach(function(label) {
                    var selector = '.%s'.replace(/%s/, label),
                        $node = $ttpc.find(selector);
                    // Update the node
                    $node.removeClass('flip hidden');
                    $node.find('.curr').text(data.curr[label]);
                    $node.find('.next').text(data.next[label]);
                    // Wait for a repaint to then flip
                    _.delay(function($node) {
                        $node.addClass('flip');
                    }, 50, $node);
                });
            }
        });
    });
});

var ttpc_countdown_tpl = '' +
        '<div class="time <%= label %>">' +
            '<span class="ttcount curr top"><%= curr %></span>' +
            '<span class="ttcount next top"><%= next %></span>' +
            '<span class="ttcount next bottom"><%= next %></span>' +
            '<span class="ttcount curr bottom"><%= curr %></span>' +
            '<span class="label"><%= label_lang.length < 6 ? label_lang : label_lang.substr(0, 3)  %></span>' +
    '</div>';